-- Create Table
CREATE TABLE [dbo].[tblIndexTest](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[SomeDate] [date] NOT NULL,
	[SomeText] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_tblIndexTest] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

-- Generate Data
insert tblIndexTest (SomeDate, SomeText)
select cast(
	cast(cast(rand(checksum(newid()))*2000 as int)+ 1000 as varchar(10)) + '-' + 
	cast(cast(rand(checksum(newid())) * 12 as int) + 1  as varchar(10)) + '-' + 
	cast(cast(rand(checksum(newid())) * 28 as int) + 1 as varchar(10))
	as date),
	N'Test Entry ' + cast(row_number() over (order by a1.object_id, a2.object_id) as nvarchar(40))
from 
master.sys.all_objects a1
cross join 
master.sys.all_objects a2
order by a1.parent_object_id, a2.parent_object_id, a2.object_id, a1.object_id
GO

-- Test Select From Table
select * from tblIndexTest 
where SomeDate between '2000-1-1' and '2009-12-31'
order by SomeDate
GO

-- Create View
create view [dbo].[vwIndexTest]
with schemabinding
as
select ID, SomeDate, SomeText
from dbo.tblIndexTest
GO

-- Test Select From View Without Index
select * from vwIndexTest 
where SomeDate between '2000-1-1' and '2009-12-31'
order by SomeDate
GO

-- Create Indexes
CREATE UNIQUE CLUSTERED INDEX [ci_vwIndexTest_ID] ON [dbo].[vwIndexTest]
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [ix_vwIndexTest_SomeDate] ON [dbo].[vwIndexTest]
(
	[SomeDate] ASC
)
INCLUDE ( 	[ID],
	[SomeText]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

-- Test Select From View With Index, but Without NOEXPAND hint
select * from vwIndexTest 
where SomeDate between '2000-1-1' and '2009-12-31'
order by SomeDate
go

-- Test Select from View With Index and NOEXPAND hint
select * from vwIndexTest 
with (noexpand)
where SomeDate between '2000-1-1' and '2009-12-31'
order by SomeDate
Go

-- Add More Data to the table
insert tblIndexTest (SomeDate, SomeText)
select cast(
	cast(cast(rand(checksum(newid()))*2000 as int)+ 1000 as varchar(10)) + '-' + 
	cast(cast(rand(checksum(newid())) * 12 as int) + 1  as varchar(10)) + '-' + 
	cast(cast(rand(checksum(newid())) * 28 as int) + 1 as varchar(10))
	as date),
	N'Test Entry ' + cast(row_number() over (order by a1.object_id, a2.object_id) as nvarchar(40))
from 
master.sys.all_objects a1
cross join 
master.sys.all_objects a2
order by a1.parent_object_id, a2.parent_object_id, a2.object_id, a1.object_id
GO

-- Test Select from View With Index and NOEXPAND hint
select * from vwIndexTest 
with (noexpand)
where SomeDate between '2000-1-1' and '2009-12-31'
order by SomeDate
Go

-- Test Select From View With Index, but Without NOEXPAND hint
select * from vwIndexTest 
where SomeDate between '2000-1-1' and '2009-12-31'
order by SomeDate
go
